<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Boilerplate
 * @since Boilerplate 1.0
 */
?><!DOCTYPE html>
<!--[if lt IE 7 ]><html <?php language_attributes(); ?> class="no-js ie ie6 lte7 lte8 lte9"><![endif]-->
<!--[if IE 7 ]><html <?php language_attributes(); ?> class="no-js ie ie7 lte7 lte8 lte9"><![endif]-->
<!--[if IE 8 ]><html <?php language_attributes(); ?> class="no-js ie ie8 lte8 lte9"><![endif]-->
<!--[if IE 9 ]><html <?php language_attributes(); ?> class="no-js ie ie9 lte9"><![endif]-->
<!--[if (gt IE 9)|!(IE)]><!--><html <?php language_attributes(); ?> class="no-js"><!--<![endif]-->
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />
		<title><?php
			/*
			 * Print the <title> tag based on what is being viewed.
			 * We filter the output of wp_title() a bit -- see
			 * boilerplate_filter_wp_title() in functions.php.
			 */
			wp_title( '|', true, 'right' );
		?></title>
		<link rel="profile" href="http://gmpg.org/xfn/11" />
		<link rel="stylesheet" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php
		/* We add some JavaScript to pages with the comment form
		 * to support sites with threaded comments (when in use).
		 */
		if ( is_singular() && get_option( 'thread_comments' ) )
			wp_enqueue_script( 'comment-reply' );



		/* Always have wp_head() just before the closing </head>
		 * tag of your theme, or you will break many plugins, which
		 * generally use this hook to add elements to <head> such
		 * as styles, scripts, and meta tags.
		 */
		wp_head();
?>
	</head>
	
<?php
global $options;
foreach ($options as $value) {
    if (get_settings( $value['id'] ) === FALSE) { $$value['id'] = $value['std']; } else { $$value['id'] = get_settings( $value['id'] ); }
}
?>
	
	
	<body <?php body_class(); ?>>
	

			<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/<?php  echo $i3s_css;  ?>.css" />

	
		<header class="main">
		<div class="wrap">
		
		<section class="tophead">
		<h1><?php  echo $i3s_site_title;  ?></h1>	
		<nav class="main">	<?php wp_nav_menu( array( 'container_class' => 'menu-header', 'theme_location' => 'primary' ) ); ?></nav>
		</section>
		
		<section class="bothead">
		
		<div class="videoContainer">
     	<iframe width="570" height="350" src="<?php  echo $i3s_video_url;  ?>" frameborder="0" allowfullscreen></iframe>
		</div>

		
		<div class="headerinfo">
		
		<h2><?php  echo $i3s_header_text;  ?></h2>
		<h3><?php  echo $i3s_sub_header_text;  ?></h3>
			<a href="<?php  echo $i3s_button_header;  ?>"><div class="button"></div></a>
		<div class="social">
		<a href="<?php  echo $i3s_facebook;  ?>"><img src="<?php bloginfo('template_directory'); ?>/images/facebook.png" /></a>
		<a href="<?php  echo $i3s_twitter;  ?>"><img src="<?php bloginfo('template_directory'); ?>/images/twitter.png" /></a>
		<a href="mailto:<?php  echo $i3s_email;  ?>"><img src="<?php bloginfo('template_directory'); ?>/images/gmail.png" /></a>
		<a href="<?php  echo $i3s_youtube;  ?>"><img src="<?php bloginfo('template_directory'); ?>/images/youtube.png" /></a>


		</div>	
		
		</div>


		</section>
		
		
		
		</div>	
		</header>
		
		<section class="main" >
		<div class="wrap">
	